//=============================================================================
// RPGツクールMZ - EnemySelectAttack.js
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 敵の行動選択における仕様を変更します。
 * @author emoriiin979
 *
 * @help EnemySelectAttack.js
 *
 * 敵の行動選択における仕様を変更します。
 *   ・レーティングが最大値-2の行動が選択されないようにします。
 */

(() => {
    "use strict";

    //-------------------------------------------------------------------------
    // Game_Enemy
    //
    // レーティングが最大・最大-1の技しか選択しないよう改変

    const _Game_Enemy_selectAction = Game_Enemy.prototype.selectAction;
    Game_Enemy.prototype.selectAction = function(actionList, ratingZero) {
        return _Game_Enemy_selectAction.call(this, actionList, ratingZero + 1);
    };
})();
